<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Admin\Role;
use Illuminate\Http\Request;
use App\Models\Admin\Website;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\AccountVerifyWithDocument;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use App\Models\Admin\UserMessage;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $website = Website::latest()->first();
        $users = User::where('role_id', 3)->latest()->paginate(50);
        // return $users;
        $roles = Role::all()->where('id', '!=', '3');

        return view('backend.pages.usermanage.user', compact('users', 'roles', 'website'));
    }
     
    public function verified_user()
    {
        $website = Website::latest()->first();
        $users = User::where('role_id', 3)->where('is_verified', 1)->latest()->paginate(15);
        $roles = Role::all()->where('id', '!=', '3');
        $title = 'Verified User';
        $search = '';

        return view('backend.pages.usermanage.user', compact('users', 'roles', 'website', 'search', 'title'));
    }
     
    public function unverified_user()
    {
        $website = Website::latest()->first();
        $users = User::where('role_id', 3)->where('is_verified', 0)->latest()->paginate(15);
        $roles = Role::all()->where('id', '!=', '3');
        $title = 'Unverified User';
        $search = '';

        return view('backend.pages.usermanage.user', compact('users', 'roles', 'website', 'search', 'title'));
    }

    public function user_search(Request $request)
    {
        $website = Website::latest()->first();
        $query = User::query();
        if ($request->search_data) {
            $query = $query->where('code', 'like', "%{$request->search_data}%");
            $query = $query->orWhere('name', 'like', "%{$request->search_data}%");
            $query = $query->orWhere('email', 'like', "%{$request->search_data}%");
        }
        $users = $query->where('role_id', 3)->latest()->paginate(15);
        $roles = Role::all()->where('id', '!=', '3');

        return view('backend.pages.usermanage.user', compact('users', 'roles', 'website'));
    }
     
    public function premium_user()
    {
        $website = Website::latest()->first();
        $users = User::where('role_id', 3)->where('premium_package_id', '!=', NULL)->latest()->paginate(15);
        $roles = Role::all()->where('id', '!=', '3');
        $title = 'Premium User';
        $search = '';

        return view('backend.pages.usermanage.premium-user', compact('users', 'roles', 'website', 'search', 'title'));
    }
    
    public function premium_user_search(Request $request)
    {
        $website = Website::latest()->first();
        $query = User::query();
        if ($request->search_data) {
            // $query = $query->where('code', $request->search_data);
            $query = $query->where('code', 'like', "%{$request->search_data}%");
            $query = $query->orWhere('name', 'like', "%{$request->search_data}%");
            $query = $query->orWhere('email', 'like', "%{$request->search_data}%");
        }
        $users = $query->where('role_id', 3)->where('premium_package_id', '!=', NULL)->latest()->paginate(15);
        $roles = Role::all()->where('id', '!=', '3');
        $title = 'Search User';
        $search = $request->search_data;

        return view('backend.pages.usermanage.premium-user', compact('users', 'roles', 'website', 'search', 'title'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'name' => 'required|min:3|max:50',
            'username' => 'required|min:3|max:50',
            'email' => 'required|unique:users',
            'phone' => 'required|unique:users',
            'role_id' => 'required',
            'password' => 'required',
        ]);

        $user = new User();
        $user->name = Str::ucfirst($request->input('name'));
        $user->username = $request->input('username');
        $user->email = $request->input('email');
        $user->role_id = $request->input('role_id');
        $user->status = '0';
        $user->password = Hash::make($request->input('password'));
        $user->phone = $request->input('phone');

        $image = $request->file('image');

        if ($image) {
            $image_name = Str::random(20);
            $ext = strtolower($image->getClientOriginalExtension());
            $image_full_name = $image_name.'.'.$ext;
            $upload_path = 'backend/img/user/';
            $image_url = $upload_path.$image_full_name;
            $success = $image->move($upload_path, $image_full_name);
            if ($success) {
                $user->image = $image_url;
                $user_insert = $user->save();
                if ($user_insert) {
                    return redirect()->route('admin.user')->with('message','User added Successfully');
                }else{
                    return redirect()->route('admin.user')->with('error','User dose not added!');
                }
            }else{
                return redirect()->route('admin.user')->with('error','Image not store to folder!');
            }
        }else{
            $user_insert = $user->save();
            if ($user_insert) {
                return redirect()->route('admin.user')->with('message','User added Successfully');
            }else{
                return redirect()->route('admin.user')->with('error','User dose not added!');
            }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
     
    
    
    public function edit($id)
    {
        $website = Website::latest()->first();
        $user = DB::table('users')->where('id', $id)->first();
        $roles = Role::all()->where('id', '!=', '3');
        return view('backend.pages.usermanage.useredit', compact('user', 'website', 'roles'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
public function user_balance(Request $request, $id)
{
    $user = User::find($id);

    // Save the current balances before updating
    $oldDepositBalance = $user->deposit_balance;
    $oldEarningBalance = $user->earning_balance;

    // Update the balances with the values from the request
    if ($request->has('update_deposit')) {
        $user->deposit_balance = $request->deposit_balance;
        $balanceType = 'deposit';
    } elseif ($request->has('update_earning')) {
        $user->earning_balance = $request->earning_balance;
        $balanceType = 'earning';
    } else {
        // Handle the case where neither button is pressed
        // You may want to redirect or show an error message
        return redirect()->back()->with('error', 'Invalid request.');
    }

    $user->save();

    // Check if the balance was credited or deducted and create a corresponding message
    $messageTitle = 'BALANCE_UPDATED';
    $message = "Your {$balanceType} balance has been";

    $amountDifference = abs($user->{$balanceType . '_balance'} - ${"old" . ucfirst($balanceType) . "Balance"});

    if ($user->{$balanceType . '_balance'} > ${"old" . ucfirst($balanceType) . "Balance"}) {
        $message .= " Credited: $".number_format($amountDifference, 2);
    } elseif ($user->{$balanceType . '_balance'} < ${"old" . ucfirst($balanceType) . "Balance"}) {
        $message .= " Deducted: $".number_format($amountDifference, 2);
    }

    // Save the balance message to the database
    $data = new UserMessage();
    $data->user_id = $id;
    $data->message_title = $messageTitle;
    $data->message = $message;
    $data->save();

    // Redirect back with a success message
    return redirect()->back()->with('message', 'Data Updated Successfully!');
}



public function user_activity(Request $request, $id)
{
    $user = User::find($id);
    $user->status = $request->status;
    $user->reason = $request->reason;
    $user->save();

    // Initialize variables
    $messageTitle = 'AUTHORITY_MESSAGE';
    $message = '';

    // Create a message only for account activation
    if ($request->status == '1') {
        $message = 'Congratulation, Your account is Activated.';
    } elseif ($request->status == '0') {
        // For account deactivation
        $message .= 'Sorry, Your account is Banned.';
        
        // Include the reason if provided
        if ($request->reason) {
            $message .= ' Reason: ' . $request->reason;
        }
    }

    // Save the message to the database if it's an activation message
    if ($message) {
        $data = new UserMessage();
        $data->user_id = $id;
        $data->message_title = $messageTitle;
        $data->message = $message;
        $data->save();
    }

    return redirect()->back()->with('message', 'Data Updated Successfully!');
}


   public function user_verification(Request $request, $id) {
    $user = User::find($id);
    
    if ($user->premium_status == 1) {
        return redirect()->back()->with('error', 'This account has already been Verified');
    }

    $user->premium_status = 1;
    $user->save();

    // Create a message for user upgrade
    $upgradeMessage = new UserMessage();
    $upgradeMessage->user_id = $user->id;
    $upgradeMessage->message_title = 'ACCOUNT_VERIFY';
    $upgradeMessage->message = 'Congratulations! Your account has been verified';
    $upgradeMessage->save();

    return redirect()->back()->with('message', 'Account verification success');
}

    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'name' => 'required|min:3|max:50',
            'email' => 'required',
        ]);

        $data = array();

        $data['name'] = Str::ucfirst($request->input('name'));
        $data['username'] = $request->input('username');
        $data['email'] = $request->input('email');
        $data['phone'] = $request->input('phone');
        $data['role_id'] = $request->input('role_id');

        $image = $request->file('image');
        // Update----------------
        if ($image) {
            $old_img = DB::table('users')->where('id', $id)->first();
            if(file_exists($old_img->image)){
                unlink($old_img->image);
            }
                
            $image_name = Str::random(20);
            $ext = strtolower($image->getClientOriginalExtension());
            $image_full_name = $image_name.'.'.$ext;
            $upload_path = 'backend/img/user/';
            $image_url = $upload_path.$image_full_name;
            $success = $image->move($upload_path, $image_full_name);
            $data['image'] = $image_url;
        }
        
        $update_user = DB::table('users')->where('id', $id)->update($data);
        if ($update_user) {
            return redirect()->back()->with('message','User upadated Successfully!');
        }else{
            return redirect()->back()->with('error','User dose not updated!');
        }
    }
    
    public function user_document_verify()
    {
        $website = Website::latest()->first();
        $website = Website::latest()->first();
        $datas = AccountVerifyWithDocument::where('status', 0)->latest()->paginate(15);
        $title = 'Verify Request';

        return view('backend.pages.usermanage.document-verify', compact('datas', 'title', 'website'));
    }
    public function user_document_verify_update(Request $request, $id){
        $document = AccountVerifyWithDocument::find($id);
        $msg_user_id = $document->user_id;
        $document->status = $request->status;
        if($request->status == 1){
            $up_user = User::find($document->user_id);
            $up_user->is_verified = 1;
            $up_user->save();
            
            $data = new UserMessage();
            $data->user_id = $msg_user_id;
            $data->message_title = 'Account Verify';
            $data->message = 'Your account successfully verified. Now you can work on it properly.';
            $data->save();
            
        }elseif($request->status == 2){
            $document->reason = $request->reason;
            
            $data = new UserMessage();
            $data->user_id = $msg_user_id;
            $data->message_title = 'Account Verify';
            $data->message = 'Your account not verified! Reason: '.$request->reason;
            $data->save();
        }
        $document->save();
        return redirect()->back()->with('message','Successfully data updated!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
     
    
    public function destroy($id)
    {
        $user = User::find($id);
        if(file_exists($user->image)){
            unlink($user->image);
        }
        $user->delete();
        return redirect()->back()->with('message','User deleted Successfully!');
    }
}
